## Code for Biological Sequence Design tasks in Our Paper
 

## Requirements
We follow the previously published implementation of the paper [Biological Sequence Design with GFlowNets](http://arxiv.org/abs/2203.04115). The setup for Anaconda environment is as follows:
1. Create new python environment with version python=3.8.13 and activate it
2. Install design-bench from our fork [`MJ10/design-bench`](https://github.com/MJ10/design-bench). To install clone the repo and run `pip install -e .` in the directory where the repo is cloned.
3. Instal the clamp-commonvia -eval library from [MJ10/clamp-gen-data](https://github.com/MJ10/clamp-gen-data). To install clone the repo via `git lfs clone git@github.com:MJ10/clamp-gen-data.git`  and run `pip install -r requirements.txt && pip install -e .` in the directory where the repo is cloned.
4. Run `pip install numpy==1.21`
5. Run `pip install torch==1.9.0+cu111 torchvision==0.10.0+cu111 torchaudio==0.9.0 -f https://download.pytorch.org/whl/torch_stable.html`
6. Run `pip install -r requirements.txt` in this directory to install the remaining packages.

## Running Instructions
The running commands are similar for AMP, TFBind8 and GFP task by running run_amp.py, run_tfbind.py and run_gfp.py correspondingly. Specifically, for AMP task we have:

- To train GFlowNets baseline with trajectory balance loss, run:
```
python run_amp.py --save_path 'amp.pkl.gz' --gen_do_reg "False"
```

- To train GFlowNets while minimizing the path regularization via OT (reg_coef > 0), run:
```
python run_amp.py --save_path 'amp_min_ot.pkl.gz' --gen_do_reg "True" --reg_method "ot" --reg_coef 0.025
```

- To train GFlowNets while minimizing the upper bound of the path regularization via OT (reg_coef > 0), run:
```
python run_amp.py --save_path 'amp_ot_upperbound.pkl.gz' --gen_do_reg "True" --reg_method "ot_upperbound" --reg_coef 0.025
```

- To train GFlowNets while maximizing the path regularization via OT (reg_coef < 0), run:
```
python run_amp.py --save_path 'amp_max_ot.pkl.gz' --gen_do_reg "True" --reg_method "ot" --reg_coef -0.025

